/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{ Copyright (c) 2003, 2005 Borland Software Corporation }
{                                                       }
{*******************************************************/

using System;
using System.Data;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.ComponentModel.Design.Serialization;
using System.Drawing;
using System.Drawing.Design;
using System.Text;


namespace Borland.Data.Web
{

	/// <summary>
	/// Summary description for Class.
	/// </summary>
	/// <summary>
	/// Data Aware Checkbox control, with datalink to text bool or valid string fields
   ///   for use with DBWebDataSource control
	/// </summary>
   #region DBWebCheckBox
	[Designer("Borland.Data.Web.DBWebControlDesigner"),
   ToolboxBitmap(typeof(Borland.Data.Web.DBWebCheckBox),
   "Borland.Data.Web.DBWebCheckBox.bmp"),
	ToolboxData("<{0}:DBWebCheckBox runat=server></{0}:DBWebCheckBox>")]
   public class DBWebCheckBox : CheckBox, IDBWebColumnLink, IPostBackDataHandler
   {
      private DBWebColumnLink FColumnLink;
      private IDBWebColumnLink IColumnLink;

   	public DBWebCheckBox() : base()
      {
         FColumnLink = new DBWebColumnLink(this);
         IColumnLink = (FColumnLink as IDBWebColumnLink);
      }

		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);
			if( Page != null )
				Page.RegisterRequiresPostBack(this);
      }

		protected override void OnPreRender(EventArgs args)
		{
			base.OnPreRender(args);
			string s = Page.Request.QueryString[DBWebConst.sBorlandImageID];
         if( s != null )
         	return;
         DataBind();
         Page.RegisterHiddenField(DBWebDataSource.IdentPrefix + this.ID, IColumnLink.TableName + DBWebConst.Splitter + IColumnLink.ColumnName);
		}

      #region IPostBackDataHandler
      // RaisePostDataChangedEvent is called prior to DataBind()
      // DataSet and related properties are NOT available here
      // Child controls are not available
	  bool IPostBackDataHandler.LoadPostData(string postDataKey,
			NameValueCollection postCollection)
	  {
		 if( this.Visible )
		 {
			FColumnLink.LoadPostData(postDataKey, postCollection);
			if( postCollection[this.ID] == null )
			{
				string PageName = ClassUtils.GetPageName(Page);
				FColumnLink.AddToSession(PageName + TableName, this.ID, "off");  // { do not localize }
			}
		 }
		 return false;
	  }

	  void IPostBackDataHandler.RaisePostDataChangedEvent()
	  {
	  }
      #endregion

      #region IDBWebDataLink
      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
      [LocalizableDescriptionAttribute("TableName")]
      public string TableName
      {
      	get
         {
	      	return IColumnLink.TableName;
         }
      	set
         {
	      	IColumnLink.TableName = value;
         }
      }
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
		DefaultValue(null)]
      [LocalizableDescriptionAttribute("DataSource")]
      public IDBDataSource DBDataSource
      {
      	get
         {
         	return IColumnLink.DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }


      [Editor(typeof(Borland.Data.Web.BooleanColumnPropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
      [LocalizableDescriptionAttribute("ColumnName")]
      public string ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }
      #endregion

   		protected override void Render(HtmlTextWriter output)
		{
      	bool error = ClassUtils.OutputErrors(Page, output, IColumnLink);
         if( !error || (IColumnLink.DBDataSource as DBWebDataSource).ErrorOption != ErrorHtmlOption.logOnErrorPage )
         	base.Render(output);
         else  // if going to a separate error hmtl page, output "OK" button.
         {
         	ClassUtils.OutputOKButton(output);
            Page.Response.End();
         }
		}

		public override void DataBind()
      {
      	try
         {
	         if( ClassUtils.IsDesignTime(Page) || !FColumnLink.IsDataBound )
   	      	Checked = false;
         	base.DataBind();
	         if( FColumnLink.IsDataBound )
   	      {
            	Checked = false;
      	   	object o = IColumnLink.DBDataSource.GetColumnValue(Page,
         	   					IColumnLink.TableName, IColumnLink.ColumnName);
            	if( o != null )
	            {
		         	string s = o.ToString();
	   	         string sTrueValues = BdwResources.GetString("TrueValues");
   	   	      if( s == null || sTrueValues.IndexOf(s.ToLower()) >= 0 )
      	   	   	Checked = true;
               }
               base.DataBind();
            }
         }
         catch(Exception ex)
         {
         	if( !ClassUtils.IsDesignTime(Page) )
            {
	            Page.Response.Write(ClassUtils.GetInternalError(Page, IColumnLink, ex, this.ID));
   	         Page.Response.End();
            }
            else
            	throw new Exception(ex.Message);
         }
      }
   }
   #endregion
}
